Imports System
Imports System.Collections.Generic
Imports System.IO
Imports Microsoft.Win32
Imports System.Linq

'Dieser Code wird in das Update-Package als vb Datei übernommen und von der alten xpectoPro-Version vor dem Update compiliert
'Diese ruft dann beim RunUpdate() als erstes CheckIfUpgradeIsPossible auf,
'dann GetUpdateDependencies() und lädt letztere, vor dem Start der neuen Exe, in das update-Verzeichnis herunter wenn nötig und
'packt den Inhalt in das Programmverzeichnis aus.

Public Class UpdateChecks
	Public Shared Function CheckIfUpgradeIsPossible(vb As eAgentur.clVBA, strFromVersion As String) As String
		If strFromVersion.StartsWith("3.") AndAlso strFromVersion < "3.28.1965" Then Return "Update not possible. Please upgrade to latest stable 28 release first: Version 3.28.1965 or newer"
		If strFromVersion.StartsWith("4.") AndAlso strFromVersion < "4.28.0564" Then Return "Update not possible. Please upgrade to latest stable 28 release first: Version 4.28.0564 or newer"
		Return Nothing
	End Function

	Public Shared Function GetUpdateDependencies(vb As eAgentur.clVBA) As String()
		Dim list As New List(Of String)

		'wir benötigen mindestens .Net Version 8.0.4. Wenn es nicht lokal installiert ist,
		'als Dependency-package herunterladen
		If GetDotNetVersionRelease(8) Is Nothing OrElse GetDotNetVersionRelease(8) < New Version(8, 0, 4) Then
			list.Add("dotnet-runtime-8.0.4 https://updates.xpecto.com/update/dotnet-8.0.4.xpectopkg")
		End If

		' Liste mit apps\xpectoPro\eAgentur.Net\Resources\Requirements.txt synchron halten!
		list.Add("textcontrol-33-sp1 https://updates.xpecto.com/update/textcontrol33-SP1.xpectopkg")
		list.Add("common-shared-libs-1.0 https://updates.xpecto.com/update/common-shared-libs-1.0.xpectopkg")
		list.Add("Grapecity-18 https://updates.xpecto.com/update/Grapecity-18.xpectopkg")
		list.Add("TxSpellDictionaries-1.0 https://updates.xpecto.com/update/TxSpellDictionaries-1.0.xpectopkg")

		Return list.ToArray()
	End Function

	' Forward Rolling release. Wir erlauben die nächste neue Version
	'https://learn.microsoft.com/en-us/dotnet/core/versions/selection#framework-dependent-apps-roll-forward
	' The host chooses the latest patch version installed on the machine. For example, if you specified net5.0 in your project file, and 5.0.2 is the latest .NET runtime installed, the 5.0.2 runtime is used.
	' If no acceptable 5.0.* version is found, a new 5.* version is used. For example, if you specified net5.0 and only 5.1.0 is installed, the application runs using the 5.1.0 runtime. This behavior is referred to as "minor version roll-forward." Lower versions also won't be considered. When no acceptable runtime is installed, the application won't run.	
	Public Shared Function GetDotNetVersionRelease(majorRelease As Integer) As Version
		Return (From x In GetDotNetVersions(majorRelease & ".*") Order By x Descending).FirstOrDefault()
	End Function

	Public Shared Function GetDotNetVersions(strVersionFilter As String) As List(Of Version)
		Dim result As New List(Of Version)
		Dim oDotnetInstallLocation As RegistryKey = Registry.LocalMachine.OpenSubKey("SOFTWARE\dotnet\Setup\InstalledVersions\x64\sharedxhost", False)
		Dim strPath As String = If(oDotnetInstallLocation IsNot Nothing, CType(oDotnetInstallLocation.GetValue("Path"), String), Nothing)

		If String.IsNullOrEmpty(strPath) Then strPath = System.Environment.GetFolderPath(System.Environment.SpecialFolder.ProgramFiles) & "\dotnet"

		Dim strNetCoreAppDir As String = strPath & "\Shared\Microsoft.NETCore.App"

		If Directory.Exists(strNetCoreAppDir) Then
			For Each strDirPath In Directory.GetDirectories(strNetCoreAppDir, strVersionFilter)
				If File.Exists(strDirPath & "\mscorlib.dll") Then
					Dim strDir As String = Path.GetFileName(strDirPath)
					If File.Exists(strPath & "\Shared\Microsoft.WindowsDesktop.App\" & strDir & "\System.Windows.Forms.dll") Then
						If strDir.Split(".").Length = 3 Then
							Try
								result.Add(Version.Parse(strDir))
							Catch
							End Try
						End If
					End If
				End If
			Next
		End If
		Return result
	End Function

End Class
